<?php

namespace App\Models;

use App\Traits\DataCedula;
use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;

final class Persona extends Model
{
    use DataCedula;
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;
    use SoftDeletes;

    protected $fillable = [
        'nombres',
        'nacionalidad',
        'cedula',
        'direccion',
        'telefono',
        'telefono_secundario',
        'whatsapp',
        'telegram',
        'correo',
        'uuid',
    ];

    public function socio(): HasOne
    {
        return $this->hasOne(Socio::class);
    }

    public function tecnico(): HasOne
    {
        return $this->hasOne(Tecnico::class);
    }

    public function vendedor(): HasOne
    {
        return $this->hasOne(Vendedor::class);
    }

    public function encargado(): HasOne
    {
        return $this->hasOne(Encargado::class);
    }

    public function cliente(): MorphOne
    {
        return $this->morphOne(Cliente::class, 'clientable');
    }

    public function toSearchableArray()
    {
        return [
            'nombres' => $this->nombres,
            'cedula' => $this->cedula,
            'telefono' => $this->telefono,
            'correo' => $this->correo,
        ];
    }
}
