<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'description',
        'type',
        'is_active',
        'tipo_metodo_pago',
        'tope'
    ];



    public function remotas()
    {
        return $this->hasMany(Remota::class, 'metodo_de_pago_id', 'id');
    }
    public function cobrosHistorial()
    {
        return $this->hasMany(CobrosHistorial::class);
    }
    public function getName()
    {
        if (is_null($this->name)) {
            $name = 'N/R';
        } else {
            $name = ucfirst($this->name);
        }

        return $name;
    }
    public function getTotalCostoAttribute()
    {
        return $this->remotas->sum(function ($remota) {
            return $remota->plan->costo ?? 0; // Asegura que no falle si `plan` es null
        });
    }
}
