<?php

namespace App\Models;

use App\Traits\GenerateUuid;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Scout\Searchable;

final class ModeloMikrotik extends Model
{
    use GenerateUuid;
    use HasFactory;
    use RouteUuid;
    use Searchable;
    use SoftDeletes;

    protected $table = 'modelos_mikrotiks';

    protected $fillable = ['nombre', 'uuid'];

    public function mikrotiks(): HasMany
    {
        return $this->hasMany(Mikrotik::class);
    }
    public function remotas(): HasMany
    {
        return $this->hasMany(Remota::class, 'tipo_router_id');
    }

    public function toSearchableArray()
    {
        return [
            'nombre' => $this->name,
        ];
    }
}
