<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Factura extends Model
{
    use HasFactory;

    protected $fillable = [
        'cobro_id',
        'numero_factura',
        'fecha_emision',
        'cliente_nombre',
        'equipo',
        'plan_nombre',
        'concepto',
        'monto_total',
        'fecha_cobro'
    ];

    protected $casts = [
        'fecha_emision' => 'date',
        'fecha_cobro' => 'date',
        'monto_total' => 'float'
    ];

    public function cobro()
    {
        return $this->belongsTo(Cobranza::class, 'cobro_id');
    }
}
