<?php

namespace App\Models;

use App\Enums\TipoConfiguracion;
use App\Traits\RouteUuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

final class Configuracion extends Model
{
    use HasFactory;
    use RouteUuid;

    protected $table = 'configuraciones';

    protected $fillable = ['valor'];

    protected $cast = [
        'tipo' => TipoConfiguracion::class,
    ];
}
