<?php

namespace App\Livewire\User;

use App\Livewire\Forms\UserProfileForm;
use App\Models\User;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;
use Livewire\Component;

final class UserProfileComponent extends Component
{
    use LivewireAlert;

    #[Locked]
    public string $uuid = '';

    public UserProfileForm $form;

    public function render()
    {
        return view('livewire.user.user-profile-component');
    }

    public function mount(string $uuid)
    {
        $this->form->fill([
            'uuid' => $uuid,
            'nombre' => $this->user->name,
            'email' => $this->user->email,
        ]);
    }

    #[Computed(persist: true)]
    public function user(): User
    {
        return User::select(['email', 'name', 'uuid', 'id'])->where('uuid', $this->uuid)->firstOrFail();
    }

    public function save()
    {
        try {
            $this->form->save($this->user());

            $this->alert('success', 'Usuario actualizado satisfactoriamente.', [
                'timer' => 5000,
            ]);

        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al actualizar el usuario.', [
                'timer' => 5000,
            ]);
        }
    }
}
