<?php

namespace App\Livewire\Tecnico;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\PersonaForm;
use App\Models\Persona;
use App\Models\Tecnico;
use Exception;
use Illuminate\Database\Eloquent\Collection;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class TecnicoFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public PersonaForm $form;

    #[Locked]
    public string $pageTitle = 'Crear Técnico';

    public string $personaSearch = '';

    public Collection $personasResult;

    #[Locked]
    public ?string $uuid = '';

    #[Locked]
    public ?string $personaUUID = '';

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();
            $this->pageTitle = "Editar {$this->persona->nombres}";
        }

        return view('livewire.tecnico.tecnico-form-component');
    }

    public function mount(?string $uuid = null)
    {
        $this->personasResult = Persona::doesntHave('tecnico')->take(100)->get(['cedula', 'nombres']);
        $this->uuid = $uuid;
        $this->personaUUID = $uuid;
    }

    #[Computed]
    public function persona()
    {
        return Persona::select(['id', 'nombres', 'cedula', 'direccion', 'telefono', 'telefono_secundario', 'whatsapp', 'telegram', 'correo'])->where('uuid', $this->personaUUID)->first();
    }

    public function updatingPersonaSearch(string $value)
    {
        $this->personasResult = Persona::doesntHave('socio')->where('nombres', 'like', "%$value%")->take(100)->get(['cedula', 'nombres']);
    }

    public function cargarPersona()
    {
        $persona = Persona::where('nombres', 'like', $this->personaSearch)->first();

        if ($persona) {
            $this->personaUUID = $persona->uuid;

            $this->form->fill([
                'nombres' => $persona->nombres,
                'nacionalidad' => $persona->nacionalidad ?? 'V',
                'cedula' => $persona->cedula ?? '',
                'direccion' => $persona->direccion,
                'telefono' => $persona->telefono,
                'telefono_secundario' => $persona->telefono_secundario,
                'whatsapp' => $persona->whatsapp,
                'telegram' => $persona->telegram,
                'correo' => $persona->correo,
            ]);

            $this->reset('personaSearch');
        }
    }

    public function save()
    {

        try {

            if ($this->personaUUID) {
                $persona = Persona::where('uuid', $this->personaUUID)->first();
                $this->form->save($persona);
            } else {
                $persona = $this->form->save();
            }

            if (Tecnico::where('persona_id', $persona->id)->first()) {
                return redirect()->route('tecnicos.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Tecnico Actualizado correctamente'
                    ]
                );
            } else {
                $persona->tecnico()->create();



                // $this->form->reset();
                $this->reset('personaUUID');
                return redirect()->route('tecnicos.index')->with(
                    [
                        'type' => 'success',
                        'message' => 'Tecnico Creado correctamente'
                    ]
                );
            }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al crear/actualizar el técnico.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'nombres' => $this->persona->nombres,
            'nacionalidad' => $this->persona->nacionalidad ?? 'V',
            'cedula' => $this->persona->cedula ?? '',
            'direccion' => $this->persona->direccion,
            'telefono' => $this->persona->telefono,
            'telefono_secundario' => $this->persona->telefono_secundario,
            'whatsapp' => $this->persona->whatsapp,
            'telegram' => $this->persona->telegram,
            'correo' => $this->persona->correo,
        ]);
    }
}
