<?php

namespace App\Livewire\Remota;

use App\Classes\LivewireFormsComponent;
use App\Enums\TipoClientes;
use App\Livewire\Forms\RemotaForm;
use App\Models\Cliente;
use App\Models\Plan;
use App\Models\Proveedor;
use App\Models\Remota;
use App\Models\Socio;
use App\Models\Vendedor;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class RemotaFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public RemotaForm $form;

    #[Locked]
    public string $pageTitle = 'Registrar Remota';

    #[Locked]
    public ?string $uuid = null;

    public $proveedor, $plan;
    public $proveedores, $planes;


    public function mount(?string $uuid = null)
    {
        $this->proveedores = Proveedor::with('empresa')->get();
        $this->planes = collect();

        $this->uuid = $uuid;
        $remota = Remota::where('uuid', $uuid)->firstOrFail();
        $this->form->tipo_router = $remota->tipoRouter->nombre;
        $this->form->cliente_uuid = $remota->cliente->uuid;
        // dd($remota->proveedor->empresa->id);
        $this->form->proveedor_uuid = $remota->proveedor->id;
        $this->form->plan_uuid = $remota->plan->id;
    }

    // public function updatedProveedor($proveedor)
    // {
    //     $this->planes = Plan::where('proveedor_id', $proveedor)->get();
    //     $this->plan = $this->planes->first()->id ?? null;
    // }

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();
            $this->pageTitle = 'Editar Remota';
        }

        $clientes = Cliente::all(['uuid', 'clientable_type', 'clientable_id']);

        // $planes = Plan::all(['uuid', 'nombre']);

        $socios = Socio::with('persona')->get(['persona_id']);

        $vendedores = Vendedor::with('persona')->get(['persona_id']);

        // $proveedores = Proveedor::with('empresa')->get();

        $data = [
            'clientes' => $clientes,
            'TipoClientes' => TipoClientes::class,
            // 'planes' => $planes,
            'socios' => $socios,
            'vendedores' => $vendedores,
            // 'proveedores' => $proveedores,
        ];

        return view('livewire.remota.remota-form-component', $data);
    }


    #[Computed(persist: true)]
    public function remota()
    {
        return Remota::with(['cliente', 'vendedor', 'plan', 'socio'])

            ->where('uuid', $this->uuid)->first();
    }

    public function save()
    {
        try {
            $this->form->save($this->remota);
            $this->form->reset();
            $this->alert('success', 'Remota registrada satisfactoriamente.', [
                'timer' => 5000,
            ]);
            unset($this->remota);
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al registrar la remota.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            // Informacion tecnica
            'equipo' => $this->form->equipo ?? $this->remota->equipo,
            'tipo_router' => $this->form->tipo_router ?? $this->remota->tipo_router,
            'puerto' => $this->form->puerto ?? $this->remota->puerto,
            'ip_gestion' => $this->form->ip_gestion ?? $this->remota->ip_gestion,
            'ubicacion' => $this->form->ubicacion ?? $this->remota->ubicacion,
            'detalle' => $this->form->detalle ?? $this->remota->detalle,
            'zona' => $this->form->zona ?? $this->remota->zona,
            'encargado' => $this->form->encargado ?? $this->remota->encargado,
            // Informacion de seriales
            'serial' => $this->form->serial ?? $this->remota->serial,
            'kit_serial' => $this->form->kit_serial ?? $this->remota->kit_serial,
            'antena_serial' => $this->form->antena_serial ?? $this->remota->antena_serial,
            // Informacion de cobro
            'dia_corte' => $this->form->dia_corte ?? $this->remota->dia_corte,
            'dia_activacion' => $this->form->dia_activacion ?? $this->remota->dia_activacion,
            'correo_cuenta' => $this->form->correo_cuenta ?? $this->remota->correo_cuenta,
            'password_correo_cuenta' => $this->form->password_correo_cuenta ?? $this->remota->password_correo_cuenta,
            'fecha_cuenta' => $this->form->fecha_cuenta ?? $this->remota->fecha_cuenta,
            // Informacion de personas
            'cliente' => $this->form->cliente_uuid ?? Cliente::find($this->remota->cliente_id)->uuid,
            'proveedor' => $this->form->proveedor_uuid ?? Proveedor::with('empresa')->find($this->remota->proveedor_id)->empresa->uuid,
            'plan' => $this->form->plan_uuid ?? Plan::find($this->remota->plan_id)->value('uuid'),
            // 'socio' => $this->form->socio ?? Socio::with('persona')->find($this->remota->socio_id)->persona->uuid,
            'vendedor' => $this->form->vendedor_uuid ?? Vendedor::with('persona')->find($this->remota->vendedor_id)->persona->uuid,
            'status' =>  $this->remota->status,
        ]);
    }
}
