<?php

namespace App\Livewire\Remota;

use App\Enums\TipoClientes;
use App\Livewire\Data\RemotaData;
use App\Models\Cobranza;
use App\Models\Remota;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Locked;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;



final class RemotaComponent extends Component
{
    use LivewireAlert;
    use WithPagination;

    // ==============Variables

    public $title = 'Remotas satelital';
    public $table_name = 'Listado de remotas satelitales';
    public $rows;
    // ====Otras
    public string $search = '';
    public $perPage = 25;


    // ==============Listeners
    protected $listeners = [
        'verDetail' => 'ola'
    ];


    public function mount()
    {
        $this->rows = Remota::where('equipo', 'LIKE', '%' . $this->search . '%')
            ->orWhere('correo_cuenta', 'LIKE', '%' . $this->search . '%')
            ->orWhere('kit_serial', 'LIKE', '%' . $this->search . '%')
            ->orWhere('antena_serial', 'LIKE', '%' . $this->search . '%')
            ->orderBy('id', 'ASC')->orderBy('equipo', 'ASC')
            ->get();
    }
    public function render()
    {
        if (session()->has('message')) $this->alert(session('type'), session('message'));
        return view('livewire.remota.remota-component');
    }




    // public function confirmDelete(string $uuid)
    // {
    //     $this->remota = $uuid;

    //     $this->alert('warning', '¿Estas seguro?', [
    //         'position' => 'center',
    //         'text' => '¡Si elimina esta remota no podra restaurarla!',
    //         'showConfirmButton' => true,
    //         'confirmButtonText' => '¡Eliminar!',
    //         'showCancelButton' => true,
    //         'cancelButtonText' => 'Cancelar',
    //         'toast' => false,
    //         'onConfirmed' => 'confirmedDelete',
    //         'onDeny' => 'deniedDelete',
    //         'timer' => null,
    //         'reverseButtons' => true,
    //         'confirmButtonColor' => '#3085d6',
    //         'cancelButtonColor' => '#d33',
    //     ]);
    // }



    #[On('confirmedDelete')]
    public function confirmedDelete()
    {
        try {
            $remota = Remota::where('uuid', $this->remota)->first();

            $cobro = Cobranza::where('remota_id')->where('status', 'pendiente')->first();
            if ($remota) {
                // if ($remota->cobros()->count() > 0) {
                //     $this->alert('error', 'No se puede eliminar la remota porque tiene cobros asociados.');
                // } else {
                // $cobro->remota_id = null;
                // $cobro->save();
                // $cobro->delete();
                $remota->delete();
                $this->alert(message: 'Remota eliminada con exito.');
                $this->search = '';
                // }
            }
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al eliminar la remota.');
        }
    }
}
