<?php

namespace App\Livewire\Persona;

use App\Classes\LivewireFormsComponent;
use App\Livewire\Forms\PersonaForm;
use App\Models\Persona;
use Exception;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Locked;

final class PersonaFormComponent extends LivewireFormsComponent
{
    use LivewireAlert;

    public PersonaForm $form;

    #[Locked]
    public string $pageTitle = 'Crear Persona';

    #[Locked]
    public ?string $uuid = null;

    public function render()
    {
        if ($this->uuid && empty($this->getErrorBag()->getMessages())) {
            $this->fillForm();
            $this->pageTitle = "Editar {$this->persona->nombres}";
        }

        return view('livewire.persona.persona-form-component');
    }

    public function mount(?string $uuid = null)
    {
        $this->uuid = $uuid;
    }

    #[Computed(persist: true)]
    public function persona()
    {
        return Persona::select(['id', 'nombres', 'cedula', 'direccion', 'telefono', 'telefono_secundario', 'whatsapp', 'telegram', 'correo'])->where('uuid', $this->uuid)->first();
    }

    public function save()
    {

        try {
            $this->form->save($this->persona);
            $this->form->reset();
            $this->alert('success', 'Persona creada satisfactoriamente.', [
                'timer' => 5000,
            ]);
            unset($this->persona);
        } catch (Exception $e) {
            throw_if(env('APP_DEBUG'), $e);
            $this->alert('error', 'Error al crear a la persona.', [
                'timer' => 5000,
            ]);
        }
    }

    protected function fillForm()
    {
        $this->form->fill([
            'nombres' => $this->persona->nombres,
            'nacionalidad' => $this->persona->nacionalidad ?? 'V',
            'cedula' => $this->persona->cedula ?? '',
            'direccion' => $this->persona->direccion,
            'telefono' => $this->persona->telefono,
            'telefono_secundario' => $this->persona->telefono_secundario,
            'whatsapp' => $this->persona->whatsapp,
            'telegram' => $this->persona->telegram,
            'correo' => $this->persona->correo,
        ]);
    }
}
