<?php

namespace App\Livewire\Home;

use App\Models\Cobranza;
use Carbon\Carbon;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Livewire\WithPagination;

class IngresoMensualActualComponent extends Component
{
    use LivewireAlert;
    use WithPagination;
    public string $search = '';
    public function updatingSearch()
    {
        $this->resetPage();
    }
    public function render()
    {
        $startOfMonth = Carbon::now()->format('Y-m-01');
        $endOfMonth = Carbon::now()->format('Y-m-t');
        // dd(Carbon::now()->format('Y-m-01'));
        $cobros = Cobranza::where('status', 'pagado')
            ->where('fecha', '>', $startOfMonth)
            ->where('fecha', '<', $endOfMonth)
            ->where('concepto', 'like', '%' . $this->search . '%')
            ->where('id',  'like', '%' . $this->search . '%')
            ->orderBy('fecha', 'desc')
            ->paginate(20);
        // $planes = Plan::search($this->search)->paginate(15);

        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.home.ingreso-mensual-actual-component', compact('cobros'));
    }
}
