<?php

namespace App\Livewire\Forms;

use App\Models\Plan;
use Illuminate\Validation\Rule;
use Livewire\Form;

final class PlanForm extends Form
{
    public string $nombre = '';

    public string $costo = '';

    public string $precio = '';

    public $proveedor_id = null;

    public ?Plan $plan = null;

    public function rules()
    {
        $plan = $this->plan;

        return [
            'nombre' => ['required', Rule::unique('planes')->ignore($plan)],
            'costo' => ['required'],
            'precio' => ['required'],
            'proveedor_id' =>  ['required', 'exists:proveedores,id']
        ];
    }

    public function messages()
    {

        return [
            'nombre.required' => "El campo es obligatorio.",
            'nombre.unique' => "Ya existe un plan registrado con ese nombre.",
            'costo.required' => "El campo es obligatorio.", 'decimal:0,2.',
            'costo.decimal' => "El costo debe tener de 0 a 2 decimales.",
            'precio.required' => "El campo es obligatorio.", 'decimal:0,2.',
            'precio' => "El precio debe tener de 0 a 2 decimales.",
            'proveedor_id.required' => "El plan debe estar registrado a un proveedor"
        ];
    }

    public function save(?Plan $plan = null)
    {
        $this->plan = $plan;
        $this->validate();

        if ($plan) {
            $this->update($plan);
        } else {
            return $this->store();
        }
    }

    private function store()
    {
        return Plan::create([
            'nombre' => $this->nombre,
            'costo' => $this->costo ?? 0,
            'precio' => $this->precio ?? 0,
            'proveedor_id' => $this->proveedor_id,
        ]);
    }

    private function update(Plan $plan)
    {
        $plan->fill([
            'nombre' => $this->nombre,
            'costo' => $this->costo ?? 0,
            'precio' => $this->precio ?? 0,
            'proveedor_id' => $this->proveedor_id,
        ]);

        $plan->save();
    }
}
