<?php

namespace App\Livewire\Forms;

use App\Models\Cliente;
use App\Models\Empresa;
use App\Models\Persona;
use App\Models\Plan;
use App\Models\Cobranza;
use Carbon\Carbon;
use Livewire\Form;

final class CobranzaForm extends Form
{
    public ?string $cliente_id = null;

    public ?string $concepto = null;

    public ?string $remota_id = null;

    public ?string $monto = null;

    public ?string $fecha = null;

    public ?Cobranza $cobranza = null;

    public function rules()
    {
        return [
            'concepto' => 'required|string',
            'cliente_id' => 'required|exists:clientes,id',
            'remota_id' => 'nullable|exists:remotas,id',
            'monto' => 'required|numeric',
            // 'fecha' => 'required|date',
        ];
    }

    public function messages()
    {
        return [
            'concepto.required' => 'El concepto es requerido',
            'concepto.string' => 'El concepto debe ser una cadena de texto',
            'cliente_id.required' => 'El cliente es requerido',
            'cliente_id.exists' => 'El cliente no existe',
            'remota_id.exists' => 'La remota no existe',
            'monto.required' => 'El monto es requerido',
            'monto.numeric' => 'El monto debe ser un número',
            // 'fecha.required' => 'La fecha es requerida',
            // 'fecha.date' => 'La fecha debe ser una fecha',

        ];
    }

    public function save(?Cobranza $cobranza = null)
    {

        $this->cobranza = $cobranza;
        $this->validate();

        if ($cobranza) {
            $this->update($cobranza);
        } else {

            return $this->store();
        }
    }

    private function store(): Cobranza
    {

        $cobranza = Cobranza::create([
            'concepto' => $this->concepto,
            'cliente_id' => Cliente::where('id', $this->cliente_id)->value('id'),
            'remota_id' => $this->remota_id,
            'monto' => $this->monto,
            'fecha' => Carbon::now(),

        ]);

        return $cobranza;
    }

    private function update(Cobranza $cobranza)
    {

        $cobranza->fill([
            'concepto' => $this->concepto,
            'cliente_id' => Cliente::where('id', $this->cliente_id)->value('id'),
            'remota_id' => $this->remota_id,
            'monto' => $this->monto,
            'fecha' => Carbon::now(),


        ]);

        $cobranza->save();
    }
}
