<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class RemotaData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public string $equipo = '',
        public string $serial = '',
        public string $kit_serial = '',
        public string $antena_serial = '',
        public string $dia_corte = '',
        public string $dia_activacion = '',
        public string $correo_cuenta = '',
        public string $password_correo_cuenta = '',
        public string $comision = '',
        public string $fecha_cuenta = '',
        public string $detalle = '',
        public string $ip_gestion = '',
        public ?ClienteData $cliente = null,
        public ?PlanData $plan = null,
        public ?SocioData $socio = null,
        public ?VendedorData $vendedor = null
    ) {}

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
