<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class PlanData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public string $nombre = '',
        public float $costo = 0.0,
        public float $precio = 0.0
    ) {
    }

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
