<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class PersonaData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public  $nombres = '',
        public  $nacionalidad = '',
        public  $cedula = '',
        public  $direccion = '',
        public  $telefono = '',
        public  $telefono_secundario = '',
        public  $telegram = '',
        public  $correo = '',
        public  $whatsapp = ''
    ) {
    }

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
