<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class MikrotikData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public string $nombre = '',
        public string $ip = '',
        public string $serial = '',
        public string $identify = '',
        public string $vpn_user = '',
        public string $vpn_password = '',
        public string $vpn_server = '',
        public ?string $ethr_corte1 = null,
        public ?string $ethr_corte2 = null,
        public string $usuario = '',
        public string $clave = '',
        public ?ModeloMikrotikData $modelo = null,
        public array $protocolos = []
    ) {
    }

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
