<?php

namespace App\Livewire\Data;

use App\Traits\StaticCreateSelf;
use App\Traits\ToArray;
use Livewire\Wireable;

final class EmpresaData implements Wireable
{
    use StaticCreateSelf;
    use ToArray;

    public function __construct(
        public string $rif = '',
        public string $razon = '',
        public string $direccion = '',
        public string $telefono = '',
        public string $telefono_secundario = '',
        public string $telegram = '',
        public string $correo = '',
        public string $whatsapp = ''
    ) {
    }

    public function toLivewire()
    {
        return $this->toArray();
    }

    public static function fromLivewire($value)
    {
        return self::create($value);
    }
}
