<?php

namespace App\Livewire\Cobranza;

use App\Models\CobrosHistorial;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Url;
use Livewire\Component;
// Eliminada la paginación de Livewire para usar DataTables

class CobrosHistorialComponent extends Component
{
    use LivewireAlert;
    // Sin WithPagination: la paginación la maneja DataTables en el cliente

    #[Url]
    public string $search = '';
    // Eliminado perPage: no se usa paginación del servidor

    // La búsqueda ya no afecta la paginación de Livewire; DataTables maneja paginación.
    // Si se desea filtrar por servidor, se mantiene el término de búsqueda.

    // public function detail(string $uuid)
    // {
    //     try {
    //         $cobranza = Cobranza::where('uuid', $uuid)->firstOrFail();

    //         $this->fill([
    //             'modalTitle' => "Información $cobranza->nombres",
    //             'detailData' => CobranzaData::create($cobranza->toArray()),
    //         ]);

    //         $this->dispatch('show-detail');
    //     } catch (ModelNotFoundException $e) {
    //         $this->alert('error', 'Cobranza no encontrada.', [
    //             'timer' => 5000,
    //         ]);
    //     } catch (Exception $e) {
    //         throw_if(env('APP_DEBUG'), $e);
    //         $this->alert('error', 'Error al mostrar el detalle de la cobranza.', [
    //             'timer' => 5000,
    //         ]);
    //     }
    // }

    // public function confirmDelete(string $uuid)
    // {
    //     $this->cobranza = $uuid;

    //     $this->alert('warning', '¿Estas seguro?', [
    //         'position' => 'center',
    //         'text' => '¡Si elimina a esta cobranza no podra restaurarla!',
    //         'showConfirmButton' => true,
    //         'confirmButtonText' => '¡Eliminar!',
    //         'showCancelButton' => true,
    //         'cancelButtonText' => 'Cancelar',
    //         'toast' => false,
    //         'onConfirmed' => 'confirmedDelete',
    //         'onDeny' => 'deniedDelete',
    //         'timer' => null,
    //         'reverseButtons' => true,
    //         'confirmButtonColor' => '#3085d6',
    //         'cancelButtonColor' => '#d33',
    //     ]);
    // }

    // public function getListeners()
    // {
    //     return [
    //         'confirmedDelete',
    //         'deniedDelete',
    //     ];
    // }

    // #[On('confirmedDelete')]
    // public function confirmedDelete()
    // {
    //     try {
    //         $cobranza = Cobranza::where('uuid', $this->cobranza)->first();

    //         if ($cobranza) {
    //             $cobranza->delete();
    //             $this->alert(message: 'Cobranza eliminada con exito');
    //         }
    //     } catch (Exception $e) {
    //         throw_if(env('APP_DEBUG'), $e);
    //         $this->alert('error', 'Error al eliminar a la cobranza');
    //     }
    // }

    // #[On('deniedDelete')]
    // public function deniedDelete()
    // {
    //     $this->cobranza = '';
    // }





    public function render()
    {
        // Ejecutar la consulta con el término de búsqueda
        $cobros_historial = CobrosHistorial::where(function ($query) {
            $query->where('concepto', 'like', '%' . $this->search . '%')
                ->orWhere('monto', 'like', '%' . $this->search . '%') // Agregar búsqueda por monto
                ->orWhereHas('remota', function ($query) {
                    $query->where('equipo', 'like', '%' . $this->search . '%');
                });
        })
            ->orderBy('created_at', 'desc')
            ->get(); // DataTables manejará paginación en cliente

        // Verificar si hay resultados
        if ($cobros_historial->isEmpty()) {
            // Si no hay resultados, ejecutar la consulta sin el término de búsqueda
            $cobros_historial = CobrosHistorial::orderBy('created_at', 'desc')->get();
        }

        logger($cobros_historial);
        if (session()->has('message')) {
            $this->alert(session('type'), session('message'));
        }

        return view('livewire.cobranza.cobros-historial-component', compact('cobros_historial'));
    }
}
