<?php

namespace App\Livewire\Cobranza;

use App\Models\Cobranza;
use App\Models\CobrosHistorial;
use App\Models\PaymentMethod;
use App\Models\Remota;
use Exception;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Livewire\WithPagination;
use Jantinnerezo\LivewireAlert\LivewireAlert;

class CobrosComponent extends Component
{
    use LivewireAlert;
    use WithPagination;

    public string $search_cobros = '';
    public $monto_cobro;
    public $fecha_cobro = '';
    public $monto_plan_a_cobrar;
    public $fecha_proximo_cobro = '';
    public $fecha_eliminacion_cobro = '';
    public $observaciones = '';
    public $payment_method_id;

    protected $listeners = [
        'listenersPagar' => 'pagar_cobro',
        'listenersExonerar' => 'exonerar_cobro',
        'listenersEliminar' => 'eliminar_cobro',
    ];



    public function updatingSearch()
    {
        $this->resetPage();
    }
    public function render()
    {

        // Cobros personalizados
        $cobros = Cobranza::where('concepto', 'like', '%' . $this->search_cobros . '%')
            ->where('status', 'pendiente')
            ->where('remota_id', NULL)->paginate();
        // Cobros de mensualidades de remotas
        $remotas_por_pagar = Cobranza::whereHas('remota', function ($query) {
            $query->where('status', 'activo');
            $query->where('equipo', 'like', '%' . $this->search_cobros . '%');
        })
            ->where('status', 'pendiente')
            ->where('remota_id', '!=', NULL)
            ->where('fecha', '<', now()->addDays(5)->format('Y-m-d'))
            ->orderBy('fecha', 'asc')
            ->paginate(8);
        // ->get();

        $payment_methods = PaymentMethod::where('tipo_metodo_pago', 'cliente')->get();
        // dd($remotas_por_pagar[0]->remota->proximaAVencer());

        $cobros_totales = Cobranza::where('concepto', 'like', '%' . $this->search_cobros . '%')
            ->where('status', 'pendiente')
            ->where('remota_id', NULL)
            ->union(
                Cobranza::whereHas('remota', function ($query) {
                    $query->where('status', 'activo');
                    $query->where('equipo', 'like', '%' . $this->search_cobros . '%');
                })
                    ->where('status', 'pendiente')
                    ->where('remota_id', '!=', NULL)
                    ->where('fecha', '<', now()->addDays(5)->format('Y-m-d'))
                    ->orderBy('fecha', 'asc')
            )
            ->get();


        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.cobros.cobros-component', compact('cobros', 'remotas_por_pagar', 'cobros_totales', 'payment_methods'));
    }



    // --------------------------- FUNCIONES
    // ------------ PAGAR
    // ------ PAGAR COBRO
    public function pagar_cobro($cobro = null, $fecha_cobro = null, $monto_cobro = null)
    {
        $cobro = Cobranza::find($cobro);
        // buscar en cobros historial si hay algunos con ese cobro_id
        if ($cobro->tieneSaldoPendiente()) {
            $new_cobro_historial = new CobrosHistorial();
            $new_cobro_historial->cliente_id = $cobro->cliente_id;
            $new_cobro_historial->cobro_id = $cobro->id;
            $new_cobro_historial->remota_id = $cobro->remota_id;
            $new_cobro_historial->fecha_pago = $fecha_cobro ?? now();
            $new_cobro_historial->monto = $monto_cobro;
            if ($cobro->cantidadPendienteDelUltimoCobroPendiente() > $monto_cobro) {
                $new_cobro_historial->concepto =  "Abono: " . $cobro->concepto;
            } else if ($cobro->cantidadPendienteDelUltimoCobroPendiente() < $monto_cobro) {
                $new_cobro_historial->concepto =  "Ultimo abono: " . $cobro->concepto;
                $cobro->status = 'pagado';
                $new_cobro_historial->utilidad = $cobro->cantidadPagadaDelUltimoCobroPendiente() + $monto_cobro - $cobro->monto;
            } else {
                $new_cobro_historial->concepto =  "Pago completo: " . $cobro->concepto;
                $cobro->status = 'pagado';
                $new_cobro_historial->utilidad = $cobro->monto;
            }
            $cobro->save();
            $new_cobro_historial->save();
        }

        return redirect()->route('cobros.index')->with(
            [
                'type' => 'success',
                'message' => 'Cobro realizado correctamente'
            ]
        );
    }

    // ------------ EXONERAR
    // ------ EXONERAR COBRO
    public function exonerar_cobro($cobro = null, $observaciones = null)
    {
        try {
            $cobro = Cobranza::find($cobro);
            DB::beginTransaction();
            $cobro->status = 'cancelado';
            $cobro->save();
            DB::commit();
            $new_cobro_historial = new CobrosHistorial();
            $new_cobro_historial->cliente_id = $cobro->cliente_id;
            $new_cobro_historial->cobro_id = $cobro->id;
            $new_cobro_historial->remota_id = null;
            $new_cobro_historial->fecha_pago =  now();
            $new_cobro_historial->monto = -$cobro->monto;
            $new_cobro_historial->concepto =  "Pago exonerado: " . $cobro->concepto;
            $new_cobro_historial->observaciones =  "Pago exonerado: " . $observaciones;
            $new_cobro_historial->save();

            DB::commit();
            return redirect()->route('cobros.index')->with(
                [
                    'type' => 'success',
                    'message' => 'Pago exonerado correctamente'
                ]
            );
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->route('cobros.index')->with(
                [
                    'type' => 'error',
                    'message' => 'Error al exonerar el pago'
                ]
            );
        }
    }

    // ------------ ELIMINAR
    // ------ ELIMINAR COBRO
    public function eliminar_cobro($cobro = null)
    {
        try {
            $cobro = Cobranza::find($cobro);
            DB::beginTransaction();
            // $cobro->status = 'cancelado';
            $cobro->delete();
            DB::commit();
            // $new_cobro_historial = new CobrosHistorial();
            // $new_cobro_historial->cliente_id = $cobro->cliente_id;
            // $new_cobro_historial->cobro_id = $cobro->id;
            // $new_cobro_historial->remota_id = null;
            // $new_cobro_historial->fecha_pago =  now();
            // $new_cobro_historial->monto = -$cobro->monto;
            // $new_cobro_historial->concepto =  "Pago exonerado: " . $cobro->concepto;
            // $new_cobro_historial->observaciones =  "Pago exonerado: " . $this->observaciones;
            // $new_cobro_historial->save();

            // DB::commit();
            return redirect()->route('cobros.index')->with(
                [
                    'type' => 'success',
                    'message' => 'Pago Eliminado correctamente'
                ]
            );
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->route('cobros.index')->with(
                [
                    'type' => 'error',
                    'message' => 'Error al eliminar el pago'
                ]
            );
        }
    }
}
