<?php

namespace App\Livewire;

use App\Models\Cliente;
use Livewire\Component;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;


class ClientesTable extends Component
{
    protected $model = Cliente::class;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
    }

    public function columns(): array
    {
        return [
            Column::make('ID', 'id')
                ->sortable(),
            Column::make('uuid')
                ->sortable(),
        ];
    }
    public function render()
    {
        return view('livewire.clientes-table');
    }
}
