<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\PaymentMethod;
use Jantinnerezo\LivewireAlert\LivewireAlert;

class PaymentMethodComponent extends Component
{
    use LivewireAlert;
    public $title = 'Metodos de pago';
    public $filas;
    public $name;
    public $description;
    public $tipo_metodo_pago;
    public $tope;
    public $paymentMethod;



    protected $listeners = [
        'deletePaymentMethod' => 'delete',
        'updatePaymentMethod' => 'update'
    ];

    protected $rules = [
        'name' => 'required|string|max:255',
        'description' => 'nullable|string|max:500',
        'tipo_metodo_pago' => 'required|in:empresa,cliente',
    ];

    public function mount()
    {
        $this->filas = PaymentMethod::all();
    }

    public function save()
    {
        $this->validate();

        PaymentMethod::create([
            'name' => $this->name,
            'description' => $this->description,
            'tipo_metodo_pago' => $this->tipo_metodo_pago,
            'tope' => $this->tope ?? null,

        ]);

        $this->alert('success', 'Metodo de pago creado con exito');
        $this->reset(['name', 'description', 'tipo_metodo_pago']);
        $this->dispatch('close-modal');  // Esta línea es correcta
        $this->mount();
    }


    // Método para eliminar un registro
    public function delete($payment_mehtod = null)
    {

        $paymentMethod = PaymentMethod::find($payment_mehtod);
        if ($paymentMethod) {
            $paymentMethod->delete();
            $this->alert('success', 'Método de pago eliminado con éxito');
            $this->mount();  // Recargar la lista después de eliminar
        } else {
            $this->alert('error', 'Método de pago no encontrado');
        }
    }
    public function update($payment_method_id = null, $name = null, $description = null, $tipo_metodo_pago = null, $tope = null, $is_active = null)
    {
        $paymentMethod = PaymentMethod::find($payment_method_id);
        if ($paymentMethod) {
            $paymentMethod->update([
                'name' => $name,
                'description' => $description,
                'tipo_metodo_pago' => $tipo_metodo_pago,
                'tope' => $tope,
                'is_active' => $is_active,
            ]);
            $this->alert('success', 'Método de pago actualizado con éxito');
            $this->mount();  // Recargar la lista después de actualizar
        } else {
            $this->alert('error', 'Método de pago no encontrado');
        }
    }


    public function render()
    {
        if (session()->has('message')) $this->alert(session('type'), session('message'));

        return view('livewire.admin.payment-method-component');
    }
}
