<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }



    public function rules(): array
    {
        return [
            'email' => [
                'required',
                'email',
                'max:255',
                'regex:/^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$/',
            ],
            'password' => [
                'required',
                'string',
                'min:8',
                'max:100',
                'regex:/^[\w@#%&*!.\-]+$/', // caracteres comunes en contraseñas
            ],
            'captcha' => [
                'required',
                'captcha'
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'email.required' => 'El correo electrónico es obligatorio.',
            'email.email' => 'El formato del correo no es válido.',
            'email.regex' => 'El correo contiene caracteres no permitidos.',
            'password.required' => 'La contraseña es obligatoria.',
            'password.min' => 'La contraseña debe tener al menos :min caracteres.',
            'password.regex' => 'La contraseña contiene caracteres no válidos.',
            'captcha.required' => 'Debe completar el captcha.',
            'captcha.captcha' => 'El captcha es incorrecto.',
        ];
    }
}
