<?php

namespace App\Http\Controllers;

use App\Enums\TipoClientes;
use App\Models\Cliente;
use Illuminate\Http\Request;

final class ClienteController extends Controller
{
    public function create(Request $request)
    {
        $data = [
            'tipoCliente' => TipoClientes::EMPRESA->getName(),
            'TipoClientes' => TipoClientes::class,
        ];

        return view('clientes.create', $data);
    }

    public function edit(string $uuid)
    {
        $cliente = Cliente::where('uuid', $uuid)->firstOrFail();
        $tipo_cliente = TipoClientes::from($cliente->clientable_type);

        // $cliente = Cliente::where('uuid', $uuid)->with('remotas')->firstOrFail();
        // dd($cliente);
        return view(
            'clientes.edit',

            [
                'uuid' => $uuid,
                'tipo_cliente' => $tipo_cliente,
                'TipoClientes' => TipoClientes::class
            ]
        );
    }
}
