<?php

namespace App\Enums;

use App\Models\Empresa;
use App\Models\Persona;

enum TipoClientes: string
{
    case PERSONA = Persona::class;
    case EMPRESA = Empresa::class;

    public function getName(): string
    {
        return match ($this) {
            TipoClientes::PERSONA => 'Persona',
            TipoClientes::EMPRESA => 'Empresa'
        };
    }

    public static function fromName(string $name): static
    {
        return match ($name) {
            'Persona' => TipoClientes::PERSONA,
            'Empresa' => TipoClientes::EMPRESA
        };
    }
}
